/*!
 * @file        usb_user.h
 *
 * @brief       usb user function
 *
 * @version     V1.0.0
 *
 * @date        2022-05-25
 *
 */
#ifndef __USB_USER_H
#define __USB_USER_H

#include "apm32f4xx.h"
#include "usb_board.h"


typedef enum
{
    USER_OK,
    USER_WAITING,
    USER_ERROR
} USER_STATE_T;

/**
 * @brief USB function type define
 */

typedef void (*USER_InitHandler_T)(void);
typedef void (*USER_DeInitHandler_T)(void);
typedef void (*USER_ResetDevHandler_T)(void);
typedef void (*USER_DevAttachedHandler_T)(void);
typedef void (*USER_DevDetachedHandler_T)(void);
typedef void (*USER_DevSpeedDetectedHandler_T)(uint8_t speed);
typedef void (*USER_DevDescHandler_T)(void *devDesc);
typedef void (*USER_CfgDescHandler_T)(void *cfgDesc, void *interface);
typedef void (*USER_ManufacturerStringHandler_T)(void * mfcDesc);
typedef void (*USER_ProductStringHandler_T)(void *productDesc);
typedef void (*USER_SerialNumStringHandler_T)(void *serialDesc);
typedef void (*USER_EnumDoneHandler_T)(void);
typedef USER_STATE_T (*USER_UserInputHandler_T)(void);
typedef USER_STATE_T (*USER_ApplicationHandler_T)(void);
typedef void (*USER_DeviceNotSupportedHandler_T)(void);
typedef void (*USER_UnrecoveredErrHandler_T)(void);
typedef void (*USER_DelayCallBack_T)(uint32_t );

/**
 * @brief   USB User Callback handler
 */
typedef struct
{
    USER_InitHandler_T               initHandler;
    USER_DeInitHandler_T             deInitHandler;
    USER_ResetDevHandler_T           resetDevHandler;
    USER_DevAttachedHandler_T        devAttachedHandler;
    USER_DevDetachedHandler_T        devDetachedHandler;
    USER_DevSpeedDetectedHandler_T   devSpeedDetectedHandler;
    USER_DevDescHandler_T            devDescHandler;
    USER_CfgDescHandler_T            cfgDescHandler;
    USER_ManufacturerStringHandler_T manufacturerStringHandler;
    USER_ProductStringHandler_T      productStringHandler;
    USER_SerialNumStringHandler_T    serialNumStringHandler;
    USER_EnumDoneHandler_T           enumDoneHandler;
    USER_UserInputHandler_T          userInputHandler;
    USER_ApplicationHandler_T        applicationHandler;
    USER_DeviceNotSupportedHandler_T deviceNotSupportedHandler;
    USER_UnrecoveredErrHandler_T     unrecoveredErrHandler;
    USER_DelayCallBack_T             delay;
} USB_UserCallBack_T;

extern USB_UserCallBack_T g_userCallback;

#endif
